/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import jemu.core.device.Device;

public class Z84C30
extends Device {
    protected int counter = 256;
    protected int maxcount = 0;
    protected int CTC0 = 127;
    protected boolean canChange = false;
    protected int[] clocks = new int[]{0, 1000000, 2000000, 3000000};
    protected int clindex;
    int cycleval;
    int portval;
    protected boolean docycle;

    public Z84C30() {
        super("Z84C30 Logic");
    }

    @Override
    public int readPort(int port) {
        if (port == 63616) {
            return this.counter == this.maxcount ? 0 : 255;
        }
        return 255;
    }

    public int getCycles() {
        return this.cycleval;
    }

    public int getClockSpeed() {
        double BYTE = this.counter;
        double d = 4.0 - 4.0 / (BYTE * 2.0 - 1.0 + 1.0);
        return (int)(d * 250000.0);
    }

    public int getCounter() {
        return this.counter;
    }

    @Override
    public void writePort(int port, int value) {
        if (port == 63616) {
            this.portval = value & 0xFF;
            if (!((value & 0xFF) != this.CTC0 && (value & 0xFF) != this.CTC0 - 8 || this.canChange)) {
                this.canChange = true;
            } else if (this.canChange) {
                this.counter = value & 0xFF;
                if (this.counter == 0) {
                    this.counter = 256;
                }
                this.cycleval = this.counter;
                this.canChange = false;
            }
        }
    }

    public boolean getCycle() {
        return this.docycle;
    }

    @Override
    public void cycle() {
        if (this.canChange) {
            --this.counter;
            if (this.counter == 0) {
                this.counter = this.maxcount;
                this.docycle = true;
            } else {
                this.docycle = false;
            }
        }
    }
}

